@extends('backend.admin-master')
@section('style')
    <link rel="stylesheet" href="{{asset('assets/backend/css/dropzone.css')}}">
    <link rel="stylesheet" href="{{asset('assets/backend/css/media-uploader.css')}}">
@endsection
@section('site-title')
    {{__('Newsletter Area')}}
@endsection
@section('content')
    <div class="col-lg-12 col-ml-12 padding-bottom-30">
        <div class="row">
            <div class="col-lg-12">
                <div class="margin-top-40"></div>
                @include('backend/partials/message')
                @include('backend/partials/error')
            </div>
            <div class="col-lg-12 mt-t">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">{{__('Newsletter Area Settings')}}</h4>

                        <form action="{{route('admin.home21.newsletter')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <nav>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    @foreach($all_languages as $key => $lang)
                                        <a class="nav-item nav-link @if($key == 0) active @endif" id="nav-home-tab" data-toggle="tab" href="#nav-home-{{$lang->slug}}" role="tab" aria-controls="nav-home" aria-selected="true">{{$lang->name}}</a>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content margin-top-30" id="nav-tabContent">
                                @foreach($all_languages as $key => $lang)
                                    <div class="tab-pane fade @if($key == 0) show active @endif" id="nav-home-{{$lang->slug}}" role="tabpanel" aria-labelledby="nav-home-tab">
                                        <div class="form-group">
                                            <label for="home_21_newsletter_section_{{$lang}}_subtitle">{{__('Sub Title')}}</label>
                                            <input type="text" name="home_21_newsletter_section_{{$lang->slug}}_subtitle" value="{{get_static_option('home_21_newsletter_section_'.$lang->slug.'_subtitle')}}" class="form-control" >
                                        </div>
                                        <div class="form-group">
                                            <label for="home_21_newsletter_section_{{$lang}}_title">{{__('Title')}}</label>
                                            <input type="text" name="home_21_newsletter_section_{{$lang->slug}}_title" value="{{get_static_option('home_21_newsletter_section_'.$lang->slug.'_title')}}" class="form-control" >
                                            <small class="info-text">{{__('use {shape}text{/shape} to show shape in the title')}}</small>
                                        </div>
                                        <div class="form-group">
                                            <label for="home_21_newsletter_section_{{$lang}}_placeholder_text">{{__('Placeholder Text')}}</label>
                                            <input type="text" name="home_21_newsletter_section_{{$lang->slug}}_placeholder_text" value="{{get_static_option('home_21_newsletter_section_'.$lang->slug.'_placeholder_text')}}" class="form-control" >
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <x-media-upload
                                    title="{{__('Shape Image')}}"
                                    name="home_21_newsletter_section_shape_image"
                                    id="{{get_static_option('home_21_newsletter_section_shape_image')}}"
                                    dimentions="770x1050"
                            />
                            <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">{{__('Update Settings')}}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('backend.partials.media-upload.media-upload-markup')
@endsection

@section('script')
    <script src="{{asset('assets/backend/js/dropzone.js')}}"></script>
    @include('backend.partials.media-upload.media-js')
@endsection
